<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use Illuminate\Http\Request;

class AdminSettingsController extends Controller
{
    public function index()
    {
        $settings = [
            'patient_registration_enabled' => Setting::get('patient_registration_enabled', false),
        ];

        return view('admin.settings', compact('settings'));
    }

    public function update(Request $request)
    {
        $validated = $request->validate([
            'patient_registration_enabled' => 'nullable|boolean',
        ]);

        Setting::set('patient_registration_enabled', $validated['patient_registration_enabled'] ?? false, 'boolean');

        return back()->with('success', 'Settings updated successfully.');
    }
}

